PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE "reviewHistory" (
    "cardId" INTEGER NOT NULL,
    time FLOAT NOT NULL,
    "lastInterval" FLOAT NOT NULL,
    "nextInterval" FLOAT NOT NULL,
    ease INTEGER NOT NULL,
    delay FLOAT NOT NULL,
    "lastFactor" FLOAT NOT NULL,
    "nextFactor" FLOAT NOT NULL,
    reps FLOAT NOT NULL,
    "thinkingTime" FLOAT NOT NULL,
    "yesCount" FLOAT NOT NULL,
    "noCount" FLOAT NOT NULL,
    PRIMARY KEY ("cardId", time)
);
CREATE TABLE media (
    id INTEGER NOT NULL,
    filename TEXT NOT NULL,
    size INTEGER NOT NULL,
    created FLOAT NOT NULL,
    "originalPath" TEXT NOT NULL,
    description TEXT NOT NULL,
    PRIMARY KEY (id)
);
CREATE TABLE sources (
    id INTEGER NOT NULL,
    name TEXT NOT NULL,
    created FLOAT NOT NULL,
    "lastSync" FLOAT NOT NULL,
    "syncPeriod" INTEGER NOT NULL,
    PRIMARY KEY (id)
);
CREATE TABLE stats (
    id INTEGER NOT NULL,
    type INTEGER NOT NULL,
    day DATE NOT NULL,
    reps INTEGER NOT NULL,
    "averageTime" FLOAT NOT NULL,
    "reviewTime" FLOAT NOT NULL,
    "distractedTime" FLOAT NOT NULL,
    "distractedReps" INTEGER NOT NULL,
    "newEase0" INTEGER NOT NULL,
    "newEase1" INTEGER NOT NULL,
    "newEase2" INTEGER NOT NULL,
    "newEase3" INTEGER NOT NULL,
    "newEase4" INTEGER NOT NULL,
    "youngEase0" INTEGER NOT NULL,
    "youngEase1" INTEGER NOT NULL,
    "youngEase2" INTEGER NOT NULL,
    "youngEase3" INTEGER NOT NULL,
    "youngEase4" INTEGER NOT NULL,
    "matureEase0" INTEGER NOT NULL,
    "matureEase1" INTEGER NOT NULL,
    "matureEase2" INTEGER NOT NULL,
    "matureEase3" INTEGER NOT NULL,
    "matureEase4" INTEGER NOT NULL,
    PRIMARY KEY (id)
);
INSERT INTO "stats" VALUES(1,0,strftime('%Y-%m-%d'),0,0.0,0.0,0.0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
INSERT INTO "stats" VALUES(2,1,strftime('%Y-%m-%d'),0,0.0,0.0,0.0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
CREATE TABLE "deckVars" (
    "key" TEXT NOT NULL,
    value TEXT,
    PRIMARY KEY ("key")
);
INSERT INTO "deckVars" VALUES('suspendLeeches','1');
INSERT INTO "deckVars" VALUES('leechFails','16');
INSERT INTO "deckVars" VALUES('pageSize','4096');
INSERT INTO "deckVars" VALUES('sortIndex','0');
INSERT INTO "deckVars" VALUES('perDay','1');
INSERT INTO "deckVars" VALUES('newActive','');
INSERT INTO "deckVars" VALUES('revActive','');
INSERT INTO "deckVars" VALUES('newInactive','');
INSERT INTO "deckVars" VALUES('revInactive','');
INSERT INTO "deckVars" VALUES('newSpacing','60');
INSERT INTO "deckVars" VALUES('mediaURL','');
INSERT INTO "deckVars" VALUES('latexPre','\documentclass[12pt]{article}
\special{papersize=3in,5in}
\usepackage[utf8]{inputenc}
\usepackage{amssymb,amsmath}
\pagestyle{empty}
\begin{document}
');
INSERT INTO "deckVars" VALUES('latexPost','\end{document}');
INSERT INTO "deckVars" VALUES('mediaLocation','');
CREATE TABLE models (
    id INTEGER NOT NULL,
    "deckId" INTEGER,
    created FLOAT NOT NULL,
    modified FLOAT NOT NULL,
    tags TEXT NOT NULL,
    name TEXT NOT NULL,
    description TEXT NOT NULL,
    features TEXT NOT NULL,
    spacing FLOAT NOT NULL,
    "initialSpacing" FLOAT NOT NULL,
    source INTEGER NOT NULL,
    PRIMARY KEY (id),
     CONSTRAINT "deckIdfk" FOREIGN KEY("deckId") REFERENCES decks (id)
);
INSERT INTO "models" VALUES(4099822866377046553,1,0.5+strftime('%s'),0.5+strftime('%s'),'Japanese','JtMW','','',0.1,60.0,0);
CREATE TABLE "cardModels" (
    id INTEGER NOT NULL,
    ordinal INTEGER NOT NULL,
    "modelId" INTEGER NOT NULL,
    name TEXT NOT NULL,
    description TEXT NOT NULL,
    active BOOLEAN NOT NULL,
    qformat TEXT NOT NULL,
    aformat TEXT NOT NULL,
    lformat TEXT,
    qedformat TEXT,
    aedformat TEXT,
    "questionInAnswer" BOOLEAN NOT NULL,
    "questionFontFamily" TEXT,
    "questionFontSize" INTEGER,
    "questionFontColour" VARCHAR(7),
    "questionAlign" INTEGER,
    "answerFontFamily" TEXT,
    "answerFontSize" INTEGER,
    "answerFontColour" VARCHAR(7),
    "answerAlign" INTEGER,
    "lastFontFamily" TEXT,
    "lastFontSize" INTEGER,
    "lastFontColour" VARCHAR(7),
    "editQuestionFontFamily" TEXT,
    "editQuestionFontSize" INTEGER,
    "editAnswerFontFamily" TEXT,
    "editAnswerFontSize" INTEGER,
    "allowEmptyAnswer" BOOLEAN NOT NULL,
    "typeAnswer" TEXT NOT NULL,
    PRIMARY KEY (id),
     FOREIGN KEY("modelId") REFERENCES models (id)
);
INSERT INTO "cardModels" VALUES(-2051768769169229282,1,4099822866377046553,'Forward','',0,'%(FRAME)s','%(PART)s',NULL,NULL,NULL,0,'Arial',20,'#000000',0,'Arial',20,'#000000',0,'Arial',20,'#FFFFFF',NULL,NULL,NULL,NULL,1,'');
INSERT INTO "cardModels" VALUES(4383620011646406073,0,4099822866377046553,'Expression','',1,'<span style="font-family: Liberation Sans; font-size: 28px; color: #000000;"><br>
%(Expression)s</span>','<span style="font-family: Liberation Sans; font-size: 22px; color: #000000;">%(Reading)s<br><br>%(Meaning)s<br><br>%(ROMAJI)s<br>%(LITERAL)s<br>%(INTER)s<br><br><small>%(COMMENT)s</small><br><br><p align="right"><small>ID: %(ID)s, Source: %(SOURCE)s, p. %(PAGE)s,<br>Lesson: %(LESSON)s, Frame: %(FRAME)s, part %(PART)s</small></p><br>
</span>',NULL,NULL,NULL,0,'Liberation Sans',28,'#000000',0,'Liberation Sans',22,'#000000',0,'Arial',20,'#ffffff',NULL,NULL,NULL,NULL,1,'');
INSERT INTO "cardModels" VALUES(6917653465064634913,2,4099822866377046553,'Reverse','',0,'%(PART)s','%(FRAME)s',NULL,NULL,NULL,0,'Arial',20,'#000000',0,'Arial',20,'#000000',0,'Arial',20,'#FFFFFF',NULL,NULL,NULL,NULL,1,'');
CREATE TABLE decks (
    id INTEGER NOT NULL,
    created FLOAT NOT NULL,
    modified FLOAT NOT NULL,
    description TEXT NOT NULL,
    version INTEGER NOT NULL,
    "currentModelId" INTEGER,
    "syncName" TEXT,
    "lastSync" FLOAT NOT NULL,
    "hardIntervalMin" FLOAT NOT NULL,
    "hardIntervalMax" FLOAT NOT NULL,
    "midIntervalMin" FLOAT NOT NULL,
    "midIntervalMax" FLOAT NOT NULL,
    "easyIntervalMin" FLOAT NOT NULL,
    "easyIntervalMax" FLOAT NOT NULL,
    delay0 INTEGER NOT NULL,
    delay1 INTEGER NOT NULL,
    delay2 FLOAT NOT NULL,
    "collapseTime" INTEGER NOT NULL,
    "highPriority" TEXT NOT NULL,
    "medPriority" TEXT NOT NULL,
    "lowPriority" TEXT NOT NULL,
    suspended TEXT NOT NULL,
    "newCardOrder" INTEGER NOT NULL,
    "newCardSpacing" INTEGER NOT NULL,
    "failedCardMax" INTEGER NOT NULL,
    "newCardsPerDay" INTEGER NOT NULL,
    "sessionRepLimit" INTEGER NOT NULL,
    "sessionTimeLimit" INTEGER NOT NULL,
    "utcOffset" FLOAT NOT NULL,
    "cardCount" INTEGER NOT NULL,
    "factCount" INTEGER NOT NULL,
    "failedNowCount" INTEGER NOT NULL,
    "failedSoonCount" INTEGER NOT NULL,
    "revCount" INTEGER NOT NULL,
    "newCount" INTEGER NOT NULL,
    "revCardOrder" INTEGER NOT NULL,
    PRIMARY KEY (id),
     FOREIGN KEY("currentModelId") REFERENCES models (id)
);
INSERT INTO "decks" VALUES(1,0.5+strftime('%s'),0.5+strftime('%s'),'',64,4099822866377046553,NULL,0.0,1.0,1.1,3.0,5.0,7.0,9.0,600,600,0.0,1,'PriorityVeryHigh','PriorityHigh','PriorityLow','',1,0,20,20,0,600,36000.0,0,0,0,0,0,0,0);
CREATE TABLE "fieldModels" (
    id INTEGER NOT NULL,
    ordinal INTEGER NOT NULL,
    "modelId" INTEGER NOT NULL,
    name TEXT NOT NULL,
    description TEXT NOT NULL,
    features TEXT NOT NULL,
    required BOOLEAN NOT NULL,
    "unique" BOOLEAN NOT NULL,
    numeric BOOLEAN NOT NULL,
    "quizFontFamily" TEXT,
    "quizFontSize" INTEGER,
    "quizFontColour" VARCHAR(7),
    "editFontFamily" TEXT,
    "editFontSize" INTEGER,
    PRIMARY KEY (id),
     FOREIGN KEY("modelId") REFERENCES models (id)
);
INSERT INTO "fieldModels" VALUES(-5630795664977536017,1,4099822866377046553,'SOURCE','','',1,0,0,'Arial',20,NULL,'1',20);
INSERT INTO "fieldModels" VALUES(-5553110771263572757,2,4099822866377046553,'PAGE','','',1,0,1,'Arial',20,NULL,'1',20);
INSERT INTO "fieldModels" VALUES(-3144617356480729989,3,4099822866377046553,'LESSON','','',1,0,1,'Arial',20,NULL,'1',20);
INSERT INTO "fieldModels" VALUES(-2999215738965308744,11,4099822866377046553,'Meaning','','',1,0,0,'Arial',20,NULL,'1',20);
INSERT INTO "fieldModels" VALUES(-2181132909246628723,8,4099822866377046553,'ROMAJI','','',0,0,0,'Arial',20,NULL,'1',20);
INSERT INTO "fieldModels" VALUES(-1638260037313543560,6,4099822866377046553,'Expression','','',1,0,0,'Arial',20,NULL,'1',20);
INSERT INTO "fieldModels" VALUES(-1189078751860718496,0,4099822866377046553,'ID','','',1,1,1,'Arial',20,NULL,'1',20);
INSERT INTO "fieldModels" VALUES(-1173925282622637540,5,4099822866377046553,'PART','','',1,0,0,'Arial',20,NULL,'1',20);
INSERT INTO "fieldModels" VALUES(-1012451004967223581,7,4099822866377046553,'Reading','','',0,0,0,'Arial',20,NULL,'1',20);
INSERT INTO "fieldModels" VALUES(1531651775939023859,12,4099822866377046553,'COMMENT','','',0,0,0,'Arial',20,NULL,'1',20);
INSERT INTO "fieldModels" VALUES(4758199433973037594,4,4099822866377046553,'FRAME','','',1,0,1,'Arial',20,NULL,'1',20);
INSERT INTO "fieldModels" VALUES(7445282706955490387,9,4099822866377046553,'LITERAL','','',0,0,0,'Arial',20,NULL,'1',20);
INSERT INTO "fieldModels" VALUES(9039306286393519299,10,4099822866377046553,'INTER','','',0,0,0,'Arial',20,NULL,'1',20);
CREATE TABLE facts (
    id INTEGER NOT NULL,
    "modelId" INTEGER NOT NULL,
    created FLOAT NOT NULL,
    modified FLOAT NOT NULL,
    tags TEXT NOT NULL,
    "spaceUntil" FLOAT NOT NULL,
    "lastCardId" INTEGER,
    PRIMARY KEY (id),
     FOREIGN KEY("modelId") REFERENCES models (id),
     CONSTRAINT "lastCardIdfk" FOREIGN KEY("lastCardId") REFERENCES cards (id)
);
CREATE TABLE "factsDeleted" (
    "factId" INTEGER NOT NULL,
    "deletedTime" FLOAT NOT NULL,
     FOREIGN KEY("factId") REFERENCES facts (id)
);
CREATE TABLE fields (
    id INTEGER NOT NULL,
    "factId" INTEGER NOT NULL,
    "fieldModelId" INTEGER NOT NULL,
    ordinal INTEGER NOT NULL,
    value TEXT NOT NULL,
    PRIMARY KEY (id),
     FOREIGN KEY("factId") REFERENCES facts (id),
     FOREIGN KEY("fieldModelId") REFERENCES "fieldModels" (id)
);
CREATE TABLE cards (
    id INTEGER NOT NULL,
    "factId" INTEGER NOT NULL,
    "cardModelId" INTEGER NOT NULL,
    created FLOAT NOT NULL,
    modified FLOAT NOT NULL,
    tags TEXT NOT NULL,
    ordinal INTEGER NOT NULL,
    question TEXT NOT NULL,
    answer TEXT NOT NULL,
    priority INTEGER NOT NULL,
    interval FLOAT NOT NULL,
    "lastInterval" FLOAT NOT NULL,
    due FLOAT NOT NULL,
    "lastDue" FLOAT NOT NULL,
    factor FLOAT NOT NULL,
    "lastFactor" FLOAT NOT NULL,
    "firstAnswered" FLOAT NOT NULL,
    reps INTEGER NOT NULL,
    successive INTEGER NOT NULL,
    "averageTime" FLOAT NOT NULL,
    "reviewTime" FLOAT NOT NULL,
    "youngEase0" INTEGER NOT NULL,
    "youngEase1" INTEGER NOT NULL,
    "youngEase2" INTEGER NOT NULL,
    "youngEase3" INTEGER NOT NULL,
    "youngEase4" INTEGER NOT NULL,
    "matureEase0" INTEGER NOT NULL,
    "matureEase1" INTEGER NOT NULL,
    "matureEase2" INTEGER NOT NULL,
    "matureEase3" INTEGER NOT NULL,
    "matureEase4" INTEGER NOT NULL,
    "yesCount" INTEGER NOT NULL,
    "noCount" INTEGER NOT NULL,
    "spaceUntil" FLOAT NOT NULL,
    "relativeDelay" FLOAT NOT NULL,
    "isDue" BOOLEAN NOT NULL,
    type INTEGER NOT NULL,
    "combinedDue" INTEGER NOT NULL,
    PRIMARY KEY (id),
     FOREIGN KEY("cardModelId") REFERENCES "cardModels" (id),
     FOREIGN KEY("factId") REFERENCES facts (id)
);
CREATE TABLE "cardsDeleted" (
    "cardId" INTEGER NOT NULL,
    "deletedTime" FLOAT NOT NULL,
     FOREIGN KEY("cardId") REFERENCES cards (id)
);
CREATE TABLE "mediaDeleted" (
    "mediaId" INTEGER NOT NULL,
    "deletedTime" FLOAT NOT NULL,
     FOREIGN KEY("mediaId") REFERENCES cards (id)
);
CREATE TABLE "modelsDeleted" (
    "modelId" INTEGER NOT NULL,
    "deletedTime" FLOAT NOT NULL,
     FOREIGN KEY("modelId") REFERENCES models (id)
);
CREATE TABLE tags (
id integer not null,
tag text not null collate nocase,
priority integer not null default 2,
primary key(id));
INSERT INTO "tags" VALUES(1,'PriorityLow',1);
INSERT INTO "tags" VALUES(2,'PriorityHigh',3);
INSERT INTO "tags" VALUES(3,'PriorityVeryHigh',4);
CREATE TABLE cardTags (
id integer not null,
cardId integer not null,
tagId integer not null,
src integer not null,
primary key(id));
ANALYZE sqlite_master;
INSERT INTO "sqlite_stat1" VALUES('tags','ix_tags_tag','3 1');
INSERT INTO "sqlite_stat1" VALUES('deckVars','sqlite_autoindex_deckVars_1','13 1');
CREATE INDEX ix_cards_factor on cards (type, factor);
CREATE INDEX ix_stats_typeDay on stats (type, day);
CREATE INDEX ix_fields_factId on fields (factId);
CREATE INDEX ix_fields_fieldModelId on fields (fieldModelId);
CREATE INDEX ix_fields_value on fields (value);
CREATE INDEX ix_media_originalPath on media (originalPath);
CREATE INDEX ix_cardsDeleted_cardId on cardsDeleted (cardId);
CREATE INDEX ix_modelsDeleted_modelId on modelsDeleted (modelId);
CREATE INDEX ix_factsDeleted_factId on factsDeleted (factId);
CREATE INDEX ix_mediaDeleted_factId on mediaDeleted (mediaId);
CREATE INDEX ix_cardTags_tagCard on cardTags (tagId, cardId);
CREATE INDEX ix_cardTags_cardId on cardTags (cardId);
CREATE INDEX ix_cards_sort on cards (question collate nocase);
CREATE INDEX ix_cards_typeCombined on cards (type, combinedDue, factId);
CREATE INDEX ix_cards_relativeDelay on cards (relativeDelay);
CREATE INDEX ix_cards_modified on cards (modified);
CREATE INDEX ix_facts_modified on facts (modified);
CREATE INDEX ix_cards_priority on cards (priority);
CREATE INDEX ix_cards_factId on cards (factId);
CREATE INDEX ix_cards_intervalDesc2 on cards (type, priority desc, interval desc, factId, combinedDue);
CREATE INDEX ix_cards_dueAsc2 on cards (type, priority desc, due, factId, combinedDue);
CREATE UNIQUE INDEX ix_media_filename on media (filename);
CREATE UNIQUE INDEX ix_tags_tag on tags (tag);
CREATE VIEW failedCards as
select * from cards
where type = 0 and isDue = 1
order by type, isDue, combinedDue;
CREATE VIEW revCardsOld as
select * from cards
where type = 1 and isDue = 1
order by priority desc, interval desc;
CREATE VIEW revCardsNew as
select * from cards
where type = 1 and isDue = 1
order by priority desc, interval;
CREATE VIEW revCardsDue as
select * from cards
where type = 1 and isDue = 1
order by priority desc, due;
CREATE VIEW revCardsRandom as
select * from cards
where type = 1 and isDue = 1
order by priority desc, factId, ordinal;
CREATE VIEW acqCardsOld as
select * from cards
where type = 2 and isDue = 1
order by priority desc, due;
CREATE VIEW acqCardsNew as
select * from cards
where type = 2 and isDue = 1
order by priority desc, due desc;
COMMIT;
